def get_all_wrappers(env):
    """Returns all the wrappers of an environment up until it hits the Game class (not including the Game class).

    Args:
        env(MultiAgentAtariEnvWrapper): the environment for which the wrappers needs to be retrieved
    """
    from stack_mdp.gym_envs.envs.custom_envs import RLSupervisorQFollowersWrapper, RLSupervisorMWFollowersWrapper
    from stable_baselines3.common.vec_env.dummy_vec_env import DummyVecEnv

    currentenv = env
    list_of_wrappers = [currentenv]
    while not ((type(currentenv) == RLSupervisorQFollowersWrapper) or (type(currentenv) == RLSupervisorMWFollowersWrapper)):
        if type(currentenv) == DummyVecEnv:
            currentenv = currentenv.envs[0] #TODO quick fix before AAMAS submission but need to be careful, it may cause bugs!
        else:
            currentenv = currentenv.env
        list_of_wrappers.append(currentenv)

    return list_of_wrappers

import numpy as np

def weights_to_action(weights, num_actions):
    probs = np.exp(weights)/sum(np.exp(weights))
    return np.random.choice([i for i in range(num_actions)], 1, p=probs)[0]


def weights_to_probs(weights, randomization_type="linear"):

    if randomization_type=="linear":
        if sum(weights)==0:
            return np.ones(len(weights))/sum(np.ones(len(weights)))
        else:
            return weights / sum(weights)

    elif randomization_type=="logit":
        return np.exp(weights)/sum(np.exp(weights))

    else:
        raise ValueError("Randomization type not supported")
